package com.bitbof.escape.entities;

import org.lwjgl.util.vector.Vector2f;

public class Camera {
	public Vector2f pos = new Vector2f(0,0), lastPos = new Vector2f(pos);
	public float damping = 0.9f;
	public float width, height;
	public float zoom = 1;
	public float speed = 0;
	
	public void update(float x, float y) {
		Vector2f temp = new Vector2f(pos);
		pos.x = x*(1-damping) + damping*lastPos.x;
		pos.y = y*(1-damping) + damping*lastPos.y;
		lastPos = temp;
		
		float sdamp = 0.99f;
		float dist = new Vector2f(lastPos.x-pos.x, lastPos.y-pos.y).length();
		speed = Math.min(dist*(1-sdamp) + speed*(sdamp), 13);
		//0-20 0 -> zoom = 1  20 -> zoom = 0.05;
		zoom = 1 - (speed/40f);
	}
	public boolean checkVisible(float x, float y) {
		float dist = new Vector2f(x-pos.x, y-pos.y).length();
		if(dist > 1000/zoom)
			return false;
		return true;
	}

}
